<?php
add_action( 'widgets_init', 'sm_load_widget_flickr' );

function sm_load_widget_flickr()
{
	register_widget('Semona_Flickr_Widget');
}

class Semona_Flickr_Widget extends WP_Widget {

	function __construct()
	{
		$widget_opts = array(
			'classname' => 'sm-widget-flickr sm-widget-social-image', 
			'description' => 'The most recent photos from flickr.'
		);
		parent::__construct( 'sm-flickr-widget', 'Semona: Flickr', $widget_opts );
	}

	function widget($args, $instance)
	{
		extract($args);

		$title = apply_filters('widget_title', $instance['title']);
		$screen_name = $instance['screen_name'];
		$number = $instance['number'];
		$api = $instance['api'];
		if( empty($api) ) {
			$api = 'f8652a4906d35e3b67faa0a4ba76e57b';
		}

		echo ($before_widget);

		if( $title ) {
			echo ( $before_title . $title . $after_title );
		}
		
		do_action( 'sm_before_widget_flickr', $instance );

		if($screen_name && $number && $api) { ?>
		<script type="text/javascript">
		function jsonFlickrApi(rsp) {
			if (rsp.stat != "ok"){
				// If this executes, something broke!
				return;
			}

			//variable "s" is going to contain
			//all the markup that is generated by the loop below
			var s = "";

			s = '<ul class="sm-social-images clearfix">';

			//this loop runs through every item and creates HTML
			for (var i=0; i < rsp.photos.photo.length; i++) {
				photo = rsp.photos.photo[ i ];

				//notice that "t.jpg" is where you change the
				//size of the image
				t_url = "http://farm" + photo.farm +
				".static.flickr.com/" + photo.server + "/" +
				photo.id + "_" + photo.secret + "_" + "s.jpg";

				p_url = "http://www.flickr.com/photos/" +
				photo.owner + "/" + photo.id;

				s += '<li>';
				s += '<a href="' + p_url + '" title="' + photo.title + '" target="_blank">';
				s += '<img src="' + t_url + '" alt="' + photo.title + '" title="' + photo.title + '"/>';
				s += '<a class="hover-link real-link" href="' + p_url + '" title="' + photo.title + '" target="_blank"></a>';
				s += '</a></li>';
			}

			s += '</ul>';

			document.write(s);
		}
		</script>
		<script type="text/javascript" src="https://api.flickr.com/services/rest/?format=json&amp;method=flickr.photos.search&amp;user_id=<?php echo ( $screen_name ); ?>&amp;api_key=<?php echo ( $api ); ?>&amp;media=photos&amp;per_page=<?php echo ( $number ); ?>&amp;privacy_filter=1"></script>
		<script type="text/javascript" src="https://api.flickr.com/services/rest/?format=json&amp;method=flickr.photos.search&amp;group_id=<?php echo ( $screen_name ); ?>&amp;api_key=<?php echo ( $api ); ?>&amp;media=photos&amp;per_page=<?php echo ( $number ); ?>&amp;privacy_filter=1"></script>
		<?php }
		
		do_action( 'sm_after_widget_flickr', $instance );

		echo ( $after_widget );
	}

	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['screen_name'] = $new_instance['screen_name'];
		$instance['number'] = $new_instance['number'];
		$instance['api'] = $new_instance['api'];

		return $instance;
	}

	function form($instance)
	{
		$defaults = array('title' => 'Photos from Flickr', 'screen_name' => '', 'number' => 6, 'api' => 'f8652a4906d35e3b67faa0a4ba76e57b');
		$instance = wp_parse_args((array) $instance, $defaults); ?>

		<p>
			<label for="<?php echo ( $this->get_field_id('title') ); ?>"><?php echo esc_html__( "Title", 'semona' ) ?>:</label>
			<input class="widefat" type="text" id="<?php echo ( $this->get_field_id('title') ); ?>" name="<?php echo ( $this->get_field_name('title') ); ?>" value="<?php echo ( $instance['title'] ); ?>" />
		</p>

		<p>
			<label for="<?php echo ( $this->get_field_id('screen_name') ); ?>"><?php echo esc_html__( "Flickr ID", 'semona' ) ?>(<a href="<?php echo esc_attr( 'http://idgettr.com/' ); ?>"><?php echo esc_html__( "Get your flickr ID", 'semona' ) ?></a>):</label>
			<input class="widefat" type="text" id="<?php echo ( $this->get_field_id('screen_name') ); ?>" name="<?php echo ( $this->get_field_name('screen_name') ); ?>" value="<?php echo ( $instance['screen_name'] ); ?>" />
		</p>


		<p>
			<label for="<?php echo ( $this->get_field_id('number') ); ?>"><?php echo esc_html__( "Number of photos to show", 'semona' ) ?>:</label>
			<input class="widefat" type="text" style="width: 30px;" id="<?php echo ( $this->get_field_id('number') ); ?>" name="<?php echo ( $this->get_field_name('number') ); ?>" value="<?php echo ( $instance['number'] ); ?>" />
		</p>

		<p>
			<label for="<?php echo ( $this->get_field_id('api') ); ?>"><?php echo esc_html__( "API key (Use default or get your own from <a href=\"http://www.flickr.com/services/apps/create/apply\">Flickr APP Garden</a>)", 'semona' ) ?>:</label>
			<input class="widefat" type="text" id="<?php echo ( $this->get_field_id('api') ); ?>" name="<?php echo ( $this->get_field_name('api') ); ?>" value="<?php echo ( $instance['api'] ); ?>" />
			<small>Default key is: f8652a4906d35e3b67faa0a4ba76e57b</small>
		</p>

	<?php
	}
}
